package cn.com.duibaboot.ext.autoconfigure.dbexec;

import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * Created by guoyanfei .
 * 2018/5/28 .
 */
@ManagementContextConfiguration
public class ExecManagementConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ExecMvcEndpoint.ExecEndpoint execEndpoint() {
        return new ExecMvcEndpoint.ExecEndpoint();
    }

    @Bean
    @ConditionalOnBean(ExecMvcEndpoint.ExecEndpoint.class)
    @ConditionalOnEnabledEndpoint("dbexec")
    public ExecMvcEndpoint execMvcEndpoint(ExecMvcEndpoint.ExecEndpoint execEndpoint) {
        return new ExecMvcEndpoint(execEndpoint);
    }

}
