package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.loader.InterceptorInstanceLoader;
import net.bytebuddy.implementation.bind.annotation.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;


/**
 * The actual byte-buddy's interceptor to intercept class instance methods.
 * In this class, it provide a bridge between byte-buddy and agent plugin.
 *

 */
public class InstMethodsInterWithOverrideArgs {
    private static final Logger logger =  LoggerFactory.getLogger(InstMethodsInterWithOverrideArgs.class.getName());

    /**
     * An {@link InstanceMethodsAroundInterceptor}
     * This name should only stay in {@link String}, the real {@link Class} type will trigger classloader failure.
     * If you want to know more, please check on books about Classloader or Classloader appointment mechanism.
     */
    private InstanceMethodsAroundInterceptor interceptor;

    /**
     * @param instanceMethodsAroundInterceptorClassName class full name.
     */
    public InstMethodsInterWithOverrideArgs(String instanceMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            interceptor = InterceptorInstanceLoader.load(instanceMethodsAroundInterceptorClassName, classLoader);
        } catch (Throwable t) {
            throw new PluginException("Can't create InstanceMethodsAroundInterceptor.", t);
        }
    }

    /**
     * Intercept the target instance method.
     *
     * @param obj target class instance.
     * @param allArguments all method arguments
     * @param method method description.
     * @param zuper the origin call ref.
     * @return the return value of target instance method.
     * @throws Exception only throw exception because of zuper.call() or unexpected exception in agent ( This is a
     * bug, if anything triggers this condition ).
     */
    @RuntimeType
    public Object intercept(@This Object obj,
        @AllArguments Object[] allArguments,
        @Origin Method method,
        @Morph OverrideCallable zuper
    ) throws Throwable {
        MethodInterceptResult result = new MethodInterceptResult();
        try {
        interceptor.beforeMethod(obj, method, allArguments, method.getParameterTypes(), result);
        } catch (Throwable t) {
            logger.error("class["+obj.getClass()+"] before method["+method.getName()+"] intercept failure", t);
        }

        Object ret = null;
        try {
            if (!result.isContinue()) {
                ret = result._ret();
            } else {
                ret = zuper.call(allArguments);
            }
        } catch (Throwable t) {
            try {
                interceptor.handleMethodException(obj, method, allArguments, method.getParameterTypes(),
                    t);
            } catch (Throwable t2) {
                logger.error("class["+obj.getClass()+"] handle method["+method.getName()+"] exception failure",t2);
            }
            throw t;
        } finally {
            try {
                ret = interceptor.afterMethod(zuper, obj, method, allArguments,
                        method.getParameterTypes(), ret);
            } catch (Throwable t) {
                logger.error("class["+obj.getClass()+"] after method["+method.getName()+"] intercept failure",t);
            }
        }
        return ret;
    }
}
