package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;

import java.lang.reflect.Method;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duiba.boot.perftest.PerfTestContext;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.MoreObjects;
import redis.clients.jedis.Jedis;

/**
 * 拦截jedis操作，在方法执行前切换dbindex，执行后切换回
 */
public class JedisMethodInterceptor implements InstanceMethodsAroundInterceptor {
    private static final Integer PERF_INDEX=1;
    private final TransmittableThreadLocal<Integer> perfMode = new TransmittableThreadLocal<>();

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            if (method.getName().equals("publish")) {
                allArguments[0]="PerfTest";
            }
            Integer state = MoreObjects.firstNonNull(perfMode.get(), 0);
            perfMode.set(++state);
            if (state > 1) return;
            PerfTestContext.debugInfo("Jedis");
            Jedis jedis = (Jedis) objInst;
            jedis.select( jedis.getDB().intValue()+PERF_INDEX);
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            Integer state = perfMode.get();
            perfMode.set(--state);
            if (state == 0) {
                Jedis jedis = (Jedis) objInst;
                jedis.select(jedis.getDB().intValue() - PERF_INDEX);
                perfMode.remove();
            }
        }
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {

    }
}
