package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

import java.util.concurrent.BlockingQueue;

/**
 * 增加监控耗时的功能
 */
public class ProfileRunnable extends MonitorRunnable {

    public ProfileRunnable(Runnable runnable) {
        super(runnable);
    }

    public ProfileRunnable(Runnable runnable, BlockingQueue<Runnable> queue) {
        super(runnable, queue);
    }

    @Override
    public void run() {
        DBTimeProfile.start();
        try {
            super.run();
        }finally{
            Runnable runnable = getRootRunnable();
            DBTimeProfile.end(runnable.getClass().getName() + ", thread:" + Thread.currentThread().getName());
        }
    }

}
