package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Feature拦截器, 提供/_disableFeature, /_enableFeature两个url,用于启用/禁用cat等特性
 * <br/>
 * 比如调用/_enableFeature?type=cat表示启用cat，调用/_disableFeature?type=cat表示禁用cat
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE + 1)//最高优先级,但不能比CharacterEncodingFilter高
public class FeatureFilter implements Filter{

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath(request);
        if(requestPath.equals("/_disableFeature")){
            enableFeature(request, response, false);
        }else if(requestPath.equals("/_enableFeature")){
            enableFeature(request, response, true);
        }else{
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void enableFeature(HttpServletRequest request, HttpServletResponse response, boolean isEnable) throws IOException {
        if(!HttpRequestUtils.isLocalRequest(request)){
            response.getWriter().write("NO PERMISSION");
            return;
        }
        String type = request.getParameter("type");
        if(StringUtils.isBlank(type)){
            response.getWriter().write("ERROR");
            return;
        }

        if(type.equals("cat") && CatUtils.isCatClassExists()){
            if(isEnable){
                CatInstance.enable();
            }else{
                CatInstance.disable();
            }
        }else{
            response.getWriter().write("ERROR");
            return;
        }

        response.getWriter().write("OK");
    }

    @Override
    public void destroy() {
    }

}
