package cn.com.duiba.boot.ext.autoconfigure.actuate;

import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;


/**
 * 使用自定义的安全拦截器，对于/refresh， /restart等http接口，只要是内网触发的，则允许执行
 */
@ManagementContextConfiguration
@Order(Ordered.LOWEST_PRECEDENCE)
public class SecurityEndpointWebMvcManagementContextConfiguration {

    public SecurityEndpointWebMvcManagementContextConfiguration(EndpointHandlerMapping endpointHandlerMapping){
        endpointHandlerMapping.setSecurityInterceptor(new CustomMvcEndpointSecurityInterceptor());
    }

}
