package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.boot.ext.autoconfigure.core.utils.CatUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

/**
 * 加入AOP，监控spring-data-mongodb执行耗时
 */
@Aspect
public class CatSpringDataMongodbPlugin {

	private static final String space = "Mongodb";

	/**
	 * 拦截MongoOperations类所有接口，记录执行耗时
	 * 
	 * @param joinPoint
	 * @return
	 * @throws Throwable
	 */
	@Around("execution(* org.springframework.data.mongodb.core.MongoOperations.*(..))")
	public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();
		return CatUtils.executeInCatTransaction(() -> joinPoint.proceed(), space, methodName);
	}

}
