package cn.com.duiba.boot.ext.autoconfigure.httpclient;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 自动构建HttpClient
 */
@Configuration
@ConditionalOnClass(HttpClient.class)
@AutoConfigureBefore(name="org.springframework.cloud.netflix.feign.ribbon.FeignRibbonClientAutoConfiguration")
public class HttpClientAutoConfiguration {

    //这个httpClient可以被业务使用，但是由于这个httpClient也会被FeignClient使用，所以注意有些参数不能设置过小
    @Bean(name="httpClient", destroyMethod = "close")
    public CloseableHttpClient httpClient(){
        return HttpClientBuilder.create()
                .setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build())
                .setMaxConnPerRoute(100)
//            .setMaxConnTotal(1000)
                .setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36")//userAgent仿真，以防第三方设置的WAF判断了UA从而调用失败.
                .disableAutomaticRetries()//禁止重试
                .disableCookieManagement()
                .useSystemProperties()//for proxy
//            .setConnectionTimeToLive()
                .setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy(){
                    @Override
                    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                        long time = super.getKeepAliveDuration(response, context);
                        if(time == -1){
                            time = 30000;//链接最多空闲30秒
                        }
                        return time;
                    }
                })
                .build();
    }
}
