package cn.com.duiba.boot.ext.autoconfigure.ons;

import cn.com.duiba.boot.ext.autoconfigure.cat.annotation.CatTransaction;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;

/**
 * ons发送者的包装类，加入cat监控功能
 */
public class ProducerWrapper implements Producer {

    private Producer producer;

    public ProducerWrapper(Producer producer){
        this.producer = producer;
    }

    @Override
    public void start() {
        producer.start();
    }

    @Override
    public void shutdown() {
        producer.shutdown();
    }

    @Override
    @CatTransaction(type="MessageQueue", name="ons.send")
    public SendResult send(Message message) {
        return producer.send(message);
    }

    @Override
    public void sendOneway(Message message) {
        producer.sendOneway(message);
    }

    @Override
    public void sendAsync(Message message, SendCallback sendCallback) {
        producer.sendAsync(message, sendCallback);
    }

    @Override
    public boolean isStarted() {
        return producer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return producer.isClosed();
    }
}
