/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.actuate;

import cn.com.duiba.boot.ext.autoconfigure.core.utils.HttpRequestUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpointSecurityInterceptor;
import org.springframework.http.HttpStatus;

public class CustomMvcEndpointSecurityInterceptor
extends MvcEndpointSecurityInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CustomMvcEndpointSecurityInterceptor.class);

    public CustomMvcEndpointSecurityInterceptor() {
        super(true, null);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean isLanReq = HttpRequestUtils.isLanRequest(request);
        if (!isLanReq) {
            this.sendFailureResponse(request, response);
        }
        return isLanReq;
    }

    private void sendFailureResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logUnauthorizedAttempt();
        response.sendError(HttpStatus.FORBIDDEN.value(), "Access is denied. ");
    }

    private void logUnauthorizedAttempt() {
        logger.warn("Someone from internet try to access actuator endpoints, Deny this request");
    }
}

