/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duiba.boot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnClass(value={Servlet.class, FeignClient.class})
@ConditionalOnWebApplication
public class CatRpcHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CatRpcHandlerInterceptor.class);
    @Value(value="${spring.application.name}")
    private String springApplicationName;
    private static final ThreadLocal<RpcCatContext> CAT_CONTEXT = new ThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod) || request.getRequestURI().equals("/error") && request.getAttribute("javax.servlet.forward.request_uri") != null) {
            return true;
        }
        if (!"true".equals(request.getHeader("X-Rpc"))) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Class<?> handlerClass = method.getDeclaringClass();
        Class<?> feignClientClass = null;
        for (Class<?> clazz : handlerClass.getInterfaces()) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class) && !clazz.isAnnotationPresent(FeignClient.class)) continue;
            feignClientClass = clazz;
            break;
        }
        if (feignClientClass == null) {
            logger.warn("[NOTIFYME]can not find any interface of class:[{}] which annotated with @FeignClient or @AdvancedFeignClient, will not report to cat", (Object)handlerClass.getName());
            return true;
        }
        method = ReflectionUtils.findMethod(feignClientClass, (String)method.getName(), (Class[])method.getParameterTypes());
        RpcContext.getContext().setMethod(method);
        if (!CatUtils.isCatEnabled()) {
            return true;
        }
        this.initRpcContext(request, method);
        String loggerName = feignClientClass.getSimpleName() + "." + method.getName();
        String type = "PigeonService";
        Transaction transaction = Cat.newTransaction((String)type, (String)loggerName);
        RpcCatContext context = this.getCatContext();
        context.setCurrentTransaction(transaction);
        this.createProviderCross(request, transaction);
        Cat.logRemoteCallServer((Cat.Context)context);
        this.setAttachment(context);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Exception ex1;
        if (!this.hasCatContext()) {
            return;
        }
        RpcCatContext context = this.getCatContext();
        Transaction transaction = context.getCurrentTransaction();
        if (ex == null && (ex1 = (Exception)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE)) != null && ex1 instanceof BizException) {
            ex = ex1;
        }
        if (ex != null) {
            if (ex instanceof BizException) {
                transaction.setStatus(String.format("BizException(message:%s,code:%s)(this exception will not trigger hystrix)", ex.getMessage(), ((BizException)ex).getCode()));
            } else {
                Cat.logError((Throwable)ex);
                transaction.setStatus((Throwable)ex);
            }
        } else {
            transaction.setStatus("0");
        }
        CatUtils.completeTransaction(transaction);
        this.clearCatContext();
        RpcContext.removeContext();
    }

    private void initRpcContext(HttpServletRequest req, Method method) {
        String catRootId = req.getHeader("_catRootMessageId");
        String catParentId = req.getHeader("_catParentMessageId");
        String catChildId = req.getHeader("_catChildMessageId");
        String catRpcClientName = req.getHeader("X-Rpc-Client");
        RpcContext.getContext().setAttachment("_catRootMessageId", catRootId);
        RpcContext.getContext().setAttachment("_catParentMessageId", catParentId);
        RpcContext.getContext().setAttachment("_catChildMessageId", catChildId);
        RpcContext.getContext().setAttachment("X-Rpc-Client", catRpcClientName);
    }

    private void setAttachment(Cat.Context context) {
        RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
        RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
        RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
    }

    private boolean hasCatContext() {
        return CAT_CONTEXT.get() != null;
    }

    private RpcCatContext getCatContext() {
        RpcCatContext context = CAT_CONTEXT.get();
        if (context == null) {
            context = this.initContext();
            CAT_CONTEXT.set(context);
        }
        return context;
    }

    private void clearCatContext() {
        CAT_CONTEXT.remove();
    }

    private RpcCatContext initContext() {
        RpcCatContext context = new RpcCatContext();
        Map<String, String> attachments = RpcContext.getContext().getAttachments();
        if (attachments != null && attachments.size() > 0) {
            for (Map.Entry<String, String> entry : attachments.entrySet()) {
                if (!"_catChildMessageId".equals(entry.getKey()) && !"_catRootMessageId".equals(entry.getKey()) && !"_catParentMessageId".equals(entry.getKey())) continue;
                context.addProperty(entry.getKey(), entry.getValue());
            }
        }
        return context;
    }

    private void completeEvent(Event event) {
        AbstractMessage message = (AbstractMessage)event;
        message.setStatus("0");
        message.setCompleted(true);
    }

    private void createProviderCross(HttpServletRequest request, Transaction transaction) {
        String consumerAppName = RpcContext.getContext().getAttachment("X-Rpc-Client");
        Event crossServerEvent = Cat.newEvent((String)"PigeonService.client", (String)(consumerAppName + "[" + request.getRemoteAddr() + ":" + request.getRemotePort() + "]"));
        this.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossServerEvent);
        Event serverEvent = Cat.newEvent((String)"PigeonService.server", (String)(this.springApplicationName + "[" + request.getLocalAddr() + ":" + request.getLocalPort() + "]"));
        this.completeEvent(serverEvent);
        transaction.addChild((Message)serverEvent);
    }

    static class RpcCatContext
    implements Cat.Context {
        private Transaction currentTransaction;
        private Map<String, String> properties = new HashMap<String, String>();

        RpcCatContext() {
        }

        public void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public Transaction getCurrentTransaction() {
            return this.currentTransaction;
        }

        public void setCurrentTransaction(Transaction currentTransaction) {
            this.currentTransaction = currentTransaction;
        }
    }
}

