/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.jackson;

import cn.com.duiba.boot.ext.autoconfigure.core.DuibaServerProperties;
import cn.com.duiba.boot.ext.autoconfigure.jackson.ProxyedClassJacksonModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class JacksonCustomAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={DuibaServerProperties.class})
    public static class CustomJackson2ObjectMapperBuilderCustomizer
    implements Jackson2ObjectMapperBuilderCustomizer,
    Ordered {
        @Resource
        private DuibaServerProperties duibaServerProperties;

        public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
            jacksonObjectMapperBuilder.failOnUnknownProperties(false);
            if (this.duibaServerProperties.isInternalMode()) {
                jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
            }
        }

        public int getOrder() {
            return -1;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    public static class ProxyedClassJacksonModuleConfiguration {
        @Bean
        public ProxyedClassJacksonModule proxyedClassJacksonModuleConfigurer() {
            return new ProxyedClassJacksonModule();
        }
    }
}

