/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"duiba.server.internal-mode"}, havingValue="false", matchIfMissing=true)
public class WebMvcCspReportAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcCspReportAutoConfiguration.class);

    public static class CspReportFilter
    implements Filter {
        private static final Logger cspReportLogger = LoggerFactory.getLogger((String)"duibaCspReportLog");

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String uri = request.getRequestURI();
            if (uri.equals("/csp/report") && request.getMethod().equalsIgnoreCase("POST")) {
                String json = IOUtils.toString((InputStream)request.getInputStream());
                cspReportLogger.warn(json);
            }
        }

        public void destroy() {
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"duiba.server.internal-mode"}, havingValue="false", matchIfMissing=true)
    public static class CspReportLogbackConfigApplicationListener
    implements ApplicationListener<ContextRefreshedEvent> {
        private boolean flag = true;

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (this.flag) {
                try {
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    JoranConfigurator configurator = new JoranConfigurator();
                    configurator.setContext((Context)loggerContext);
                    configurator.doConfigure(new ClassPathResource("/logback/csp-report-logback.xml").getInputStream());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                this.flag = false;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
    @ConditionalOnProperty(value={"duiba.server.internal-mode"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnWebApplication
    public static class CspReportFilterConfiguration {
        @Bean
        public FilterRegistrationBean cspReportFilterConfigurer() {
            CspReportFilter filter = new CspReportFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/csp/report");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(Integer.MIN_VALUE);
            return registrationBean;
        }
    }
}

