/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duiba.boot.utils.JarVersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.util.ClassUtils;

public class EurekaClientBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EurekaClientBeanDefinitionRegistryPostProcessor.class);
    private static boolean isVersionMatch;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (isVersionMatch) {
            BeanDefinition eurekaClientBeanDefinition = null;
            try {
                eurekaClientBeanDefinition = registry.getBeanDefinition("eurekaClient");
            }
            catch (NoSuchBeanDefinitionException e) {
                return;
            }
            if (eurekaClientBeanDefinition == null) {
                return;
            }
            eurekaClientBeanDefinition.setScope("singleton");
            BeanDefinition eurekaClientOriginatingBeanDefinition = eurekaClientBeanDefinition.getOriginatingBeanDefinition();
            if (eurekaClientOriginatingBeanDefinition == null) {
                return;
            }
            eurekaClientOriginatingBeanDefinition.setScope("singleton");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    static {
        boolean isClassExists = ClassUtils.isPresent((String)"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration", (ClassLoader)EurekaClientBeanDefinitionRegistryPostProcessor.class.getClassLoader());
        if (isClassExists) {
            boolean isVersionMatch;
            String version = JarVersionUtils.getJarVersion(EurekaClientAutoConfiguration.class);
            EurekaClientBeanDefinitionRegistryPostProcessor.isVersionMatch = isVersionMatch = version.equals("1.4.3.RELEASE") || version.equals("1.4.4.RELEASE");
            if (!isVersionMatch) {
                logger.error("\u8bf7\u5347\u7ea7spring-cloud\u5230\u5982\u4e0b\u7248\u672c\uff1a mavenBom 'org.springframework.cloud:spring-cloud-dependencies:Edgware.SR2', (\u5982\u5f53\u524d\u4f7f\u7528\u7684\u7248\u672c\u5df2\u7ecf\u9ad8\u4e8e\u6b64\u7248\u672c\uff0c\u5219\u901a\u77e5\u67b6\u6784\u7ec4\u4fee\u6539\u5bf9\u6b64\u7248\u672c\u7684\u517c\u5bb9\u6027)");
            }
        }
    }
}

