/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.config;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class DuibaEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Map<String, Object> defProperties;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!application.isWebEnvironment()) {
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(defProperties);
        MapPropertySource propertySource = new MapPropertySource("duibaBootDefaultConfig", properties);
        environment.getPropertySources().addLast((PropertySource)propertySource);
        this.configEmbedServletContainerProperties(environment, properties);
        this.configRedisProperties(environment, properties);
        this.configEurekaProperties(environment, properties);
    }

    private void configEmbedServletContainerProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        String undertowWorkerThreads = environment.getProperty("server.undertow.workerThreads");
        if (StringUtils.isBlank((CharSequence)undertowWorkerThreads)) {
            undertowWorkerThreads = environment.getProperty("server.undertow.worker-threads");
        }
        if (!StringUtils.isBlank((CharSequence)undertowWorkerThreads)) {
            return;
        }
        String tomcatWorkerThreads = environment.getProperty("server.tomcat.maxThreads");
        if (StringUtils.isBlank((CharSequence)undertowWorkerThreads)) {
            tomcatWorkerThreads = environment.getProperty("server.tomcat.max-threads");
        }
        if (!StringUtils.isBlank((CharSequence)tomcatWorkerThreads)) {
            properties.put("server.undertow.worker-threads", tomcatWorkerThreads);
        } else {
            properties.put("server.undertow.worker-threads", "200");
        }
    }

    private void configRedisProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        String property = "spring.autoconfigure.exclude";
        String excludeAutoConfigClasses = StringUtils.defaultString((String)environment.getProperty(property), null);
        excludeAutoConfigClasses = Joiner.on((String)",").skipNulls().join((Object)excludeAutoConfigClasses, (Object)RedisAutoConfiguration.class.getName(), new Object[0]);
        properties.put(property, excludeAutoConfigClasses);
        if (StringUtils.isBlank((CharSequence)environment.getProperty("duiba.redis.host"))) {
            properties.put("spring.data.redis.repositories.enabled", "false");
        }
    }

    private void configEurekaProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        String contextPath = environment.getProperty("server.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            contextPath = environment.getProperty("server.contextPath");
        }
        if (!StringUtils.isBlank((CharSequence)contextPath)) {
            properties.put("eureka.instance.home-page-url-path", contextPath);
        }
    }

    static {
        HashMap<String, String> overrideProperties = new HashMap<String, String>();
        overrideProperties.put("spring.metrics.servo.enabled", "false");
        overrideProperties.put("spring.metrics.export.enabled", "false");
        overrideProperties.put("ribbon.eager-load.enabled", "true");
        overrideProperties.put("management.health.elasticsearch.enabled", "false");
        overrideProperties.put("management.health.mail.enabled", "false");
        overrideProperties.put("management.health.cassandra.enabled", "false");
        overrideProperties.put("management.health.couchbase.enabled", "false");
        overrideProperties.put("management.health.mongo.enabled", "false");
        overrideProperties.put("management.health.rabbit.enabled", "false");
        overrideProperties.put("management.health.redis.enabled", "false");
        overrideProperties.put("management.health.solr.enabled", "false");
        overrideProperties.put("spring.http.encoding.force", "true");
        defProperties = Collections.unmodifiableMap(overrideProperties);
    }
}

