/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import cn.com.duibaboot.ext.autoconfigure.datasource.DuibaDataSourceProperties;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;

public class DataSourceBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceBeanDefinitionRegistryPostProcessor.class);
    private static final String DATA_SOURCE_NAME_PREFIX = "DataSource";
    protected static final String DUIBA_DATA_SOURCE_CONFIG_PREFIX = "duiba.datasource";
    private DuibaDataSourceProperties duibaDataSourceProperties;
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.duibaDataSourceProperties == null) {
            return;
        }
        for (Map.Entry entry : this.duibaDataSourceProperties.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            String dataSourceBeanName = this.normalizationDataSourceName(dataSourceName);
            DuibaDataSourceProperties.DataSourcePropertiesInner props = (DuibaDataSourceProperties.DataSourcePropertiesInner)entry.getValue();
            AbstractBeanDefinition bd = props.initializeDataSourceBeanDefinitionBuilder().getBeanDefinition();
            registry.registerBeanDefinition(dataSourceBeanName, (BeanDefinition)bd);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @EventListener(value={EnvironmentChangeEvent.class})
    public void onEvent(EnvironmentChangeEvent e) {
        String prefix = "duiba.datasource.";
        HashSet<String> dataSourceNamesNeedChange = new HashSet<String>();
        for (String key : e.getKeys()) {
            if (key == null || !key.startsWith(prefix)) continue;
            String dataSourceName = key.substring(prefix.length());
            dataSourceName = dataSourceName.substring(0, dataSourceName.indexOf(46));
            dataSourceNamesNeedChange.add(dataSourceName);
        }
        for (String dataSourceName : dataSourceNamesNeedChange) {
            DataSource ds;
            String dataSourceBeanName = this.normalizationDataSourceName(dataSourceName);
            try {
                ds = (DataSource)this.beanFactory.getBean(dataSourceBeanName, DataSource.class);
            }
            catch (NoSuchBeanDefinitionException e1) {
                logger.warn("refresh datasource \u65f6\u627e\u4e0d\u5230\u540d\u4e3a\uff1a" + dataSourceBeanName + "\u7684bean\uff0c\u4e0d\u652f\u6301\u8fd0\u884c\u65f6\u6dfb\u52a0\u6570\u636e\u6e90\uff0c\u5982\u9700\u6dfb\u52a0\u6570\u636e\u6e90\uff0c\u8bf7\u91cd\u542f", (Throwable)e1);
                continue;
            }
            catch (BeanNotOfRequiredTypeException e2) {
                logger.warn("refresh datasource \u65f6\u540d\u4e3a\uff1a" + dataSourceBeanName + "\u7684bean\u4e0d\u662fDataSource\u7c7b\u578b\uff0c\u800c\u662f\uff1a" + e2.getActualType().getName() + "\u7c7b\u578b\uff0c\u4e0d\u652f\u6301refresh.", (Throwable)e2);
                continue;
            }
            PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)this.environment, prefix + dataSourceName);
            DuibaDataSourceProperties.DataSourcePropertiesInner props = resolver.bindToConfig(new DuibaDataSourceProperties.DataSourcePropertiesInner());
            props.bindProperties(dataSourceBeanName, ds);
        }
    }

    private String normalizationDataSourceName(String dataSourceName) {
        if (!dataSourceName.endsWith(DATA_SOURCE_NAME_PREFIX)) {
            dataSourceName = dataSourceName + DATA_SOURCE_NAME_PREFIX;
        }
        return dataSourceName;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)environment, DUIBA_DATA_SOURCE_CONFIG_PREFIX);
        DuibaDataSourceProperties duibaDataSourceProperties = new DuibaDataSourceProperties();
        resolver.bindToConfig(duibaDataSourceProperties);
        if (duibaDataSourceProperties.isEmpty()) {
            return;
        }
        for (String dataSourceName : duibaDataSourceProperties.keySet()) {
            DuibaDataSourceProperties.DataSourcePropertiesInner props = new DuibaDataSourceProperties.DataSourcePropertiesInner();
            resolver = new PropertyResolver((AbstractEnvironment)environment, "duiba.datasource." + dataSourceName);
            resolver.bindToConfig(props);
            duibaDataSourceProperties.put(dataSourceName, props);
        }
        this.duibaDataSourceProperties = duibaDataSourceProperties;
    }
}

