/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.datasource.DataSourceBeanDefinitionRegistryPostProcessor;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DuibaDataSourceAutoConfiguration {
    @Bean
    public static BeanDefinitionRegistryPostProcessor dataSourceBeanDefinitionRegistryPostProcessor() {
        return new DataSourceBeanDefinitionRegistryPostProcessor();
    }

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class})
    public static class Dbcp2DataSourcePostProcessorConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor<BasicDataSource> basicDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<BasicDataSource>(){

                @Override
                public Class<BasicDataSource> getBeanType() {
                    return BasicDataSource.class;
                }

                @Override
                public Object postProcessBeforeInitialization(BasicDataSource bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(BasicDataSource bean, String beanName) throws BeansException {
                    bean.setRemoveAbandonedOnBorrow(true);
                    bean.setRemoveAbandonedOnMaintenance(true);
                    bean.setLogAbandoned(true);
                    bean.setTestOnBorrow(false);
                    if (bean.getTimeBetweenEvictionRunsMillis() == -1L) {
                        bean.setTimeBetweenEvictionRunsMillis(90000L);
                    }
                    if (bean.getMaxWaitMillis() == -1L) {
                        bean.setMaxWaitMillis(3000L);
                    }
                    bean.setMinEvictableIdleTimeMillis(600000L);
                    bean.setValidationQuery("/* ping */ SELECT 1");
                    bean.setTestWhileIdle(true);
                    return bean;
                }

                public int getOrder() {
                    return -100;
                }
            };
        }
    }
}

