/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import mousio.etcd4j.EtcdClient;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.etcd", ignoreUnknownFields=false)
public class EtcdEndpoint
extends AbstractEndpoint<Data> {
    private EtcdClient etcd;

    public EtcdEndpoint(EtcdClient etcd) {
        super("etcd", false, true);
        this.etcd = etcd;
    }

    public Data invoke() {
        Data data = new Data();
        data.setVersion(this.etcd.getVersion());
        return data;
    }

    public static class Data {
        private String version;

        public Data() {
        }

        public Data(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return this.version != null ? this.version.equals(data.version) : data.version == null;
        }

        public int hashCode() {
            return this.version != null ? this.version.hashCode() : 0;
        }

        public String toString() {
            return String.format("Data{version='%s'}", this.version);
        }
    }
}

