/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomHttpMessageConverters;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnWebApplication
public class HttpMessageConvertersPostProcessorConfiguration {
    @Bean
    public SpecifiedBeanPostProcessor httpMessageConvertersPostProcessor() {
        return new SpecifiedBeanPostProcessor<HttpMessageConverters>(){

            public int getOrder() {
                return 0;
            }

            @Override
            public Class<HttpMessageConverters> getBeanType() {
                return HttpMessageConverters.class;
            }

            @Override
            public Object postProcessBeforeInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                List converters = bean.getConverters();
                return new CustomHttpMessageConverters(false, converters == null ? Collections.emptyList() : converters);
            }
        };
    }
}

