/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.gclog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class GclogDownloadMvcEndpoint
extends AbstractNamedMvcEndpoint {
    public GclogDownloadMvcEndpoint() {
        super("gclogDownload", "/gclogDownload", true);
    }

    @RequestMapping(method={RequestMethod.GET})
    public void invoke(@RequestParam String path, HttpServletResponse response) throws IOException {
        if (!path.startsWith("/dev/shm")) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
        }
        File file = new File(path);
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
        response.setContentLength((int)file.length());
        byte[] buffer = new byte[4096];
        try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());
             BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            int n = -1;
            while ((n = input.read(buffer, 0, 4096)) > -1) {
                output.write(buffer, 0, n);
            }
            output.flush();
            response.flushBuffer();
        }
    }
}

