/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.graceclose.DuibaBootBanner;
import cn.com.duibaboot.ext.autoconfigure.web.BootMonitorCheckFilter;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.netflix.discovery.EurekaClient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.env.ConfigurableEnvironment;

public class GracefulCloseRunListener
implements SpringApplicationRunListener {
    private static final Logger logger = LoggerFactory.getLogger(GracefulCloseRunListener.class);
    private SpringApplication application;
    private static boolean startingCalled = false;

    public GracefulCloseRunListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    public void started() {
    }

    public void starting() {
        System.setProperty("org.apache.catalina.connector.RECYCLE_FACADES", "true");
        if (!startingCalled) {
            startingCalled = true;
            this.application.setBannerMode(Banner.Mode.OFF);
            new DuibaBootBanner().printBanner(System.out);
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
        if (context == null || !(context instanceof EmbeddedWebApplicationContext)) {
            return;
        }
        this.printHomePageUrl(context);
        try {
            Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
            Field field = clazz.getDeclaredField("hooks");
            field.setAccessible(true);
            IdentityHashMap hooks = (IdentityHashMap)field.get(null);
            ArrayList keys2remove = new ArrayList();
            for (Map.Entry entry : hooks.entrySet()) {
                String hookClassName = ((Thread)entry.getKey()).getClass().getName();
                if (hookClassName.equals("java.util.logging.LogManager$Cleaner") || hookClassName.equals("org.unidal.helper.Threads$Manager$1") || hookClassName.startsWith("org.jacoco.agent.rt") || hookClassName.startsWith("org.quartz")) continue;
                logger.debug("remove shotdownhook:{}", (Object)hookClassName);
                keys2remove.add(entry.getKey());
            }
            for (Thread t : keys2remove) {
                hooks.remove(t);
            }
            this.addShutDownHook(context);
        }
        catch (IllegalStateException clazz) {
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addShutDownHook(final ConfigurableApplicationContext context) {
        Runtime.getRuntime().addShutdownHook(new Thread("ShutDownThread"){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                if (!logger.isInfoEnabled()) {
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    loggerContext.getLogger(GracefulCloseRunListener.class).setLevel(Level.INFO);
                }
                logger.info("begin to shutdown server...");
                logger.info("disable /monitor/check");
                BootMonitorCheckFilter.setInService(false);
                try {
                    Class.forName("com.netflix.discovery.EurekaClient");
                    EurekaClient eurekaClient = (EurekaClient)context.getBean(EurekaClient.class);
                    if (eurekaClient != null) {
                        logger.info("unregister from eureka-server");
                        eurekaClient.shutdown();
                    }
                }
                catch (ClassNotFoundException | NoSuchBeanDefinitionException eurekaClient) {
                    // empty catch block
                }
                try {
                    Class.forName("com.alibaba.dubbo.config.ProtocolConfig");
                    logger.info("clean up dubbo");
                    ProtocolConfig.destroyAll();
                }
                catch (ClassNotFoundException | ExceptionInInitializerError eurekaClient) {
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
                SimpleApplicationEventMulticaster multicaster = (SimpleApplicationEventMulticaster)context.getBean("applicationEventMulticaster", SimpleApplicationEventMulticaster.class);
                if (multicaster != null) {
                    multicaster.setTaskExecutor((Executor)TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(1, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("spring-event-multicaster-"))));
                }
                logger.info("clean up spring");
                try {
                    context.close();
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
                long period = System.currentTimeMillis() - start;
                logger.info("shutdown server finished successfully\uff0ccost\uff1a{} ms, bye bye...", (Object)period);
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.stop();
            }
        });
    }

    private void printHomePageUrl(ConfigurableApplicationContext context) {
        Class mainApplicationClass = this.application.getMainApplicationClass();
        ch.qos.logback.classic.Logger mainLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((Class)mainApplicationClass);
        mainLogger.setLevel(Level.INFO);
        String port = context.getEnvironment().getProperty("server.port");
        String contextPath = context.getEnvironment().getProperty("server.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            contextPath = context.getEnvironment().getProperty("server.contextPath");
        }
        contextPath = StringUtils.trimToEmpty((String)contextPath);
        String profile = context.getEnvironment().getProperty("spring.profiles.active");
        mainLogger.info("current profile:{}, home page: http://localhost:{}{}", new Object[]{profile, port, contextPath});
    }
}

