/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.ClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreRiskException;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreUtils;
import java.net.URI;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;

public class SsreAsyncRestTemplateWrapper
extends AsyncRestTemplate
implements ClientWrapper {
    @Override
    public boolean trySetClient(Object client) {
        if (client == null || !AsyncRestTemplate.class.isAssignableFrom(client.getClass())) {
            return false;
        }
        BeanUtils.copyProperties((Object)client, (Object)this);
        return true;
    }

    protected <T> ListenableFuture<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        try {
            SsreUtils.checkSsre(url);
        }
        catch (SsreRiskException e) {
            SettableListenableFuture future = new SettableListenableFuture();
            future.setException((Throwable)e);
            return future;
        }
        return super.doExecute(url, method, requestCallback, responseExtractor);
    }
}

