/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.ClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreAsyncRestTemplateWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpAsyncClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreRestTemplateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SsreBeanPostProcessor
implements BeanPostProcessor {
    private Logger logger = LoggerFactory.getLogger(SsreBeanPostProcessor.class);
    private Set<String> whitePackages = Sets.newLinkedHashSet();
    private Set<Class<? extends ClientWrapper>> wrapperClassSet = Sets.newLinkedHashSet();

    public SsreBeanPostProcessor() {
        this.whitePackages.add("cn.com.duibaboot");
        this.whitePackages.add("org.springframework.boot");
        this.whitePackages.add("org.springframework.cloud");
        this.wrapperClassSet.add(SsreHttpClientWrapper.class);
        this.wrapperClassSet.add(SsreHttpAsyncClientWrapper.class);
        this.wrapperClassSet.add(SsreRestTemplateWrapper.class);
        this.wrapperClassSet.add(SsreAsyncRestTemplateWrapper.class);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (!this.checkPackage(clazz.getPackage())) {
            return bean;
        }
        List<Field> fields = this.getFieldList(clazz);
        for (Field field : fields) {
            CanAccessInsideNetwork canAccess = field.getAnnotation(CanAccessInsideNetwork.class);
            if (canAccess != null) continue;
            for (Class<? extends ClientWrapper> clientClazz : this.wrapperClassSet) {
                try {
                    ClientWrapper wrapper = clientClazz.newInstance();
                    field.setAccessible(true);
                    if (!wrapper.trySetClient(field.get(bean))) continue;
                    field.set(bean, wrapper);
                }
                catch (Exception e) {
                    this.logger.error("Client\u4ee3\u7406\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return bean;
    }

    public void setWhitePackage(Set<String> whitePackage) {
        this.whitePackages.addAll(whitePackage);
    }

    private List<Field> getFieldList(Class clazz) {
        if (null == clazz) {
            return Collections.emptyList();
        }
        Object[] fields = clazz.getDeclaredFields();
        ArrayList fieldList = Lists.newArrayList((Object[])fields);
        Class superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return fieldList;
        }
        fieldList.addAll(this.getFieldList(superClass));
        return fieldList;
    }

    private boolean checkPackage(Package pakeage) {
        if (pakeage == null) {
            return false;
        }
        String packageName = pakeage.getName();
        for (String whitePackage : this.whitePackages) {
            if (!StringUtils.startsWith((CharSequence)packageName, (CharSequence)whitePackage)) continue;
            return false;
        }
        return true;
    }
}

