/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.ClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreRiskException;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreUtils;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class SsreHttpAsyncClientWrapper
extends CloseableHttpAsyncClient
implements ClientWrapper {
    private CloseableHttpAsyncClient client;

    public boolean isRunning() {
        return this.client.isRunning();
    }

    public void start() {
        this.client.start();
    }

    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        try {
            SsreUtils.checkSsre(requestProducer.getTarget());
        }
        catch (SsreRiskException e) {
            BasicFuture future = new BasicFuture(callback);
            future.failed((Exception)e);
            return future;
        }
        return this.client.execute(requestProducer, responseConsumer, context, callback);
    }

    @Override
    public boolean trySetClient(Object client) {
        if (client == null || !CloseableHttpAsyncClient.class.isAssignableFrom(client.getClass())) {
            return false;
        }
        this.client = (CloseableHttpAsyncClient)client;
        return true;
    }
}

