/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourcesResolver {
    private final Logger logger = LoggerFactory.getLogger((String)PluginResourcesResolver.class.getName());

    public List<URL> getResources() {
        ArrayList<URL> cfgUrlPaths = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = this.getDefaultClassLoader().getResources("agent-plugin.def");
            while (urls.hasMoreElements()) {
                URL pluginUrl = urls.nextElement();
                cfgUrlPaths.add(pluginUrl);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("find agent plugin define in " + pluginUrl);
            }
            return cfgUrlPaths;
        }
        catch (IOException e) {
            this.logger.error("read resources failure.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = PluginResourcesResolver.class.getClassLoader();
        }
        return cl;
    }
}

