/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.security.SecurityFilter;
import cn.com.duibaboot.ext.autoconfigure.security.SecurityPolicyProperties;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.FileUploudDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.XmlDefensivePolicy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Import(value={SecurityPolicyProperties.class})
public class SecurityAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public SecurityFilter securityFilter() {
        return new SecurityFilter();
    }

    @Bean
    public FilterRegistrationBean securityFilterConfigurer(SecurityFilter securityFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)securityFilter);
        ArrayList urlPatterns = Lists.newArrayList();
        urlPatterns.add("/*");
        registrationBean.setUrlPatterns((Collection)urlPatterns);
        registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        registrationBean.setOrder(-2147483638);
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={MultipartResolver.class})
    public FileUploudDefensivePolicy fileUploudDefensivePolicy() {
        return new FileUploudDefensivePolicy();
    }

    @Bean
    @ConditionalOnMissingBean
    public XmlDefensivePolicy xmlDefensivePolicy() {
        return new XmlDefensivePolicy();
    }

    @Bean
    @ConditionalOnProperty(name={"duiba.security.csrf.enable"}, havingValue="true")
    public CsrfDefensivePolicy csrfDefensivePolicy() {
        return new CsrfDefensivePolicy();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (!this.applicationContext.containsBean("csrfDefensivePolicy")) {
            return;
        }
        CsrfDefensivePolicy csrfDefensivePolicy = (CsrfDefensivePolicy)((Object)this.applicationContext.getBean(CsrfDefensivePolicy.class));
        registry.addInterceptor((HandlerInterceptor)csrfDefensivePolicy).addPathPatterns(new String[]{"/**"});
    }
}

