/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.login;

import cn.com.duibaboot.ext.autoconfigure.web.login.DuibaBootLoginProperties;
import cn.com.duibaboot.ext.autoconfigure.web.login.IgnoreLoginCheck;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginRunTimeException;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginState;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginStateService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.net.URLEncoder;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class DuibaBootLoginInterceptor
extends HandlerInterceptorAdapter {
    private static final Set<String> EXCLUDE_PATHS = Sets.newHashSet();
    @Autowired
    private LoginStateService loginStateService;
    @Autowired
    private DuibaBootLoginProperties duibaBootLoginProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.loginStateService.setRequestInThreadLocal(request, response);
        String url = request.getRequestURI();
        if (EXCLUDE_PATHS.contains(url)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        IgnoreLoginCheck ignoreLoginCheck = (IgnoreLoginCheck)handlerMethod.getMethodAnnotation(IgnoreLoginCheck.class);
        if (ignoreLoginCheck != null) {
            return true;
        }
        LoginState loginState = this.loginStateService.getCurrentLoginState();
        if (loginState == null || StringUtils.isBlank((String)loginState.getLoginTicket())) {
            this.returnNotLogin(request, response, handlerMethod);
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.loginStateService.removeRequestInThreadLocal();
    }

    private boolean isAjaxRequest(HandlerMethod handlerMethod) {
        ResponseBody responseBodyAnno = (ResponseBody)handlerMethod.getMethodAnnotation(ResponseBody.class);
        RestController restAnno = handlerMethod.getBeanType().getAnnotation(RestController.class);
        return responseBodyAnno != null || restAnno != null || handlerMethod.getMethod().getReturnType().equals(Void.TYPE);
    }

    private String getLoginRedirectUrl(HttpServletRequest request) {
        return this.duibaBootLoginProperties.getLoginPagePath() + "?redirect=" + this.getCurrentRedirect(request);
    }

    private void returnNotLogin(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler) {
        try {
            if (this.isAjaxRequest(handler)) {
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("success", (Object)false);
                model.put("notLogin", (Object)true);
                model.put("message", (Object)"\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
                response.getWriter().write(model.toJSONString());
            } else {
                response.sendRedirect(this.getLoginRedirectUrl(request));
            }
        }
        catch (Exception e) {
            throw new LoginRunTimeException(e);
        }
    }

    private String getCurrentRedirect(HttpServletRequest request) {
        String queryString;
        StringBuilder stringBuilder = new StringBuilder();
        String urlPath = request.getRequestURI();
        if (StringUtils.isBlank((String)urlPath)) {
            stringBuilder.append("/");
        }
        if (StringUtils.isNotBlank((String)(queryString = request.getQueryString()))) {
            stringBuilder.append("?").append(queryString);
        }
        try {
            return URLEncoder.encode(stringBuilder.toString(), "utf-8");
        }
        catch (Exception e) {
            throw new LoginRunTimeException(e);
        }
    }

    static {
        EXCLUDE_PATHS.add("/favicon.ico");
        EXCLUDE_PATHS.add("/monitor/check");
        EXCLUDE_PATHS.add("/swagger-ui.html");
        EXCLUDE_PATHS.add("/swagger-resources");
        EXCLUDE_PATHS.add("/swagger-resources/configuration/ui");
        EXCLUDE_PATHS.add("/v2/api-docs");
        EXCLUDE_PATHS.add("/error");
    }
}

