/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.login;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.web.login.DuibaBootLoginProperties;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginState;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginStateManager;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginSuccessEvent;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class LoginStateService<T> {
    private static final String LOGIN_TICKET = "loginTicket";
    private static TransmittableThreadLocal<LoginState> LOGIN_STATE = new TransmittableThreadLocal();
    @Autowired
    private LoginStateManager<T> loginStateManager;
    @Autowired
    private DuibaBootLoginProperties duibaBootLoginProperties;
    @Autowired
    private ApplicationContext applicationContext;

    void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        String loginTicket = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equals((CharSequence)LOGIN_TICKET, (CharSequence)cookie.getName())) continue;
                loginTicket = cookie.getValue();
            }
        }
        LOGIN_STATE.set((Object)new LoginState(request, response, loginTicket));
    }

    LoginState getCurrentLoginState() {
        LoginState state = (LoginState)LOGIN_STATE.get();
        if (state == null) {
            throw new RejectedExecutionException("\u5f53\u524d\u7ebf\u7a0b\u4e0d\u662f\u7528\u6237\u8bf7\u6c42\u7ebf\u7a0b");
        }
        return state;
    }

    public T getSession() {
        LoginState state = this.getCurrentLoginState();
        if (state == null || StringUtils.isBlank((CharSequence)state.getLoginTicket())) {
            return null;
        }
        return this.loginStateManager.getSessionByTicket(state.getLoginTicket());
    }

    public void createSession(T session) {
        String ticket = UUIDUtils.createSecureUUID();
        LoginState state = this.getCurrentLoginState();
        this.loginStateManager.saveSession(ticket, session);
        int expiryDate = this.duibaBootLoginProperties.getCookieExpiryDate() * 24 * 60 * 60;
        Cookie cookie = new Cookie(LOGIN_TICKET, ticket);
        cookie.setPath("/");
        cookie.setMaxAge(expiryDate);
        state.getResponse().addCookie(cookie);
        LoginSuccessEvent event = new LoginSuccessEvent();
        event.setSession(session);
        event.setRequest(state.getRequest());
        event.setResponse(state.getResponse());
        event.setExpirationTime(expiryDate);
        this.applicationContext.publishEvent((Object)event);
    }

    void removeRequestInThreadLocal() {
        LOGIN_STATE.remove();
    }
}

