package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import java.util.Map;

/**
 * Eureka元数据注册器，使用者只需要实现此接口并注册为spring的bean，框架会自动扫描并应用；我们会在首次注册到eureka或者应用被刷新(/refresh)时调用该bean的接口。
 */
public interface DiscoveryMetadataRegister {

    /**
     * 注册元数据到eureka中，这个方法会在首次注册到eureka或者应用被刷新(/refresh)时被调用。
     * @param appMetadata
     */
    void registerMetadata(Map<String, String> appMetadata);
}
