package cn.com.duibaboot.ext.autoconfigure.perftest.httpclient;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.springframework.beans.BeansException;

/**
 * 让CloseableHttpAsyncClient支持线上压测
 */
public class HttpAsyncClientPostProcessor implements SpecifiedBeanPostProcessor<CloseableHttpAsyncClient> {
    @Override
    public Class<CloseableHttpAsyncClient> getBeanType() {
        return CloseableHttpAsyncClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return new HttpAsyncClientWrapper(bean);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
