package cn.com.duibaboot.ext.autoconfigure.security;


import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.FileUploudDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.XmlDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.XssDefensivePolicy;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.*;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import java.util.EnumSet;
import java.util.List;

@Configuration
@ConditionalOnWebApplication
@Import(SecurityPolicyProperties.class)
public class SecurityAutoConfiguration extends WebMvcConfigurerAdapter {

    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public SecurityFilter securityFilter(){
        return new SecurityFilter();
    }

    @Bean
    public FilterRegistrationBean securityFilterConfigurer(SecurityFilter securityFilter){
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter(securityFilter);
        List<String> urlPatterns= Lists.newArrayList();
        urlPatterns.add("/*");//拦截路径，可以添加多个
        registrationBean.setUrlPatterns(urlPatterns);
        registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE + 10);//在CharacterFilter后面
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(MultipartResolver.class)
    public FileUploudDefensivePolicy fileUploudDefensivePolicy(){
        return new FileUploudDefensivePolicy();
    }

    @Bean
    @ConditionalOnMissingBean
    public XmlDefensivePolicy xmlDefensivePolicy(){
        return new XmlDefensivePolicy();
    }

    @Bean
    @ConditionalOnProperty(name = "duiba.security.csrf.enable", havingValue="true")
    public CsrfDefensivePolicy csrfDefensivePolicy(){
        return new CsrfDefensivePolicy();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass({ Servlet.class, DispatcherServlet.class,WebMvcConfigurerAdapter.class })
    @ConditionalOnResource(resources = "/autoconfig_xss.properties")
    public XssDefensivePolicy xssDefensivePolicy(){
        return new XssDefensivePolicy();
    }


    @Override
    public void addInterceptors(InterceptorRegistry registry) {

        if(!applicationContext.containsBean("csrfDefensivePolicy")){
            return;
        }
        CsrfDefensivePolicy csrfDefensivePolicy = applicationContext.getBean(CsrfDefensivePolicy.class);
        registry.addInterceptor(csrfDefensivePolicy).addPathPatterns("/**");
    }

}
