package cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.XssHttpServletRequestWrapper;
import com.google.common.collect.Sets;
import org.springframework.http.MediaType;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;


/**
 * 配置防止XSS攻击，对于所有输入参数进行转义。request.getParameter/request.getHeader/request.getCookies 得到的结果均为经过转义的
 * Created by wenqi.huang on 2017/3/8.
 */
public class XssDefensivePolicy implements DefensivePolicy {

    @Override
    public Set<MediaType> getMediaTypes() {
        return Sets.newHashSet(MediaType.ALL);
    }

    @Override
    public HttpServletRequest preprocessorRequest(HttpServletRequest request) {
        if(isFeignRequest(request)){
            return request;
        }else{
            return new XssHttpServletRequestWrapper(request);
        }
    }

    @Override
    public void doDefensive(HttpServletRequest request, HttpServletResponse response) throws DuibaSecurityException {
        //no thing to do
    }

    /**
     * 判断是否是来自内网的Feign请求（spring-cloud调用）
     * @param request
     * @return
     */
    private boolean isFeignRequest(HttpServletRequest request){
        if (!"true".equals(request.getHeader(CustomRequestInterceptor.X_RPC))) {
            return false;
        }

        //是feign调用的情况下还得验证请求来自内网，否则会有安全问题
        if(!HttpRequestUtils.isLanRequest(request)){
            return false;
        }

        return true;
    }
}
