package cn.com.duibaboot.ext.autoconfigure.web;


import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.web.login.DuibaBootLoginInterceptor;
import cn.com.duibaboot.ext.autoconfigure.web.login.DuibaBootLoginProperties;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginStateService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(name = "duiba.boot.login.enable", havingValue="true")
@Import(DuibaBootLoginProperties.class)
public class WebLoginAutoConfiguration extends WebMvcConfigurerAdapter{

    @Autowired
    private DuibaBootLoginProperties duibaBootLoginProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {

        DuibaBootLoginInterceptor loginInterceptor = applicationContext.getBean(DuibaBootLoginInterceptor.class);
        InterceptorRegistration registration = registry.addInterceptor(loginInterceptor)
                .addPathPatterns(duibaBootLoginProperties.getPathPatterns());
        if(StringUtils.isNotBlank(duibaBootLoginProperties.getExcludePathPatterns())){
            registration.excludePathPatterns(duibaBootLoginProperties.getExcludePathPatterns());
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public DuibaBootLoginInterceptor duibaBootLoginInterceptor(){
        return new  DuibaBootLoginInterceptor();
    }

    @Bean
    public LoginStateService loginStateService(){
        return new LoginStateService();
    }

}
