package cn.com.duibaboot.ext.autoconfigure.web.login;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "duiba.boot.login")
public class DuibaBootLoginProperties {

    /**
     * 登录模块开关
     */
    private Boolean enable = false;
    /**
     * 登录页跳转地址
     */
    private String loginPagePath = "/login";
    /**
     * 登录拦截器拦截范围
     */
    private String pathPatterns = "/**";
    /**
     * 登录拦截器排除路径
     */
    private String excludePathPatterns;
    /**
     * 登录态有效期(天)
     */
    private Integer cookieExpiryDate = 1;

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getLoginPagePath() {
        return loginPagePath;
    }

    public void setLoginPagePath(String loginPagePath) {
        this.loginPagePath = loginPagePath;
    }

    public String getPathPatterns() {
        return pathPatterns;
    }

    public void setPathPatterns(String pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    public String getExcludePathPatterns() {
        return excludePathPatterns;
    }

    public void setExcludePathPatterns(String excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }

    public Integer getCookieExpiryDate() {
        return cookieExpiryDate;
    }

    public void setCookieExpiryDate(Integer cookieExpiryDate) {
        this.cookieExpiryDate = cookieExpiryDate;
    }
}
