package cn.com.duibaboot.ext.autoconfigure.web.login;

/**
 * 登录态管理器
 * @param <T> 登录态对应的用户实体
 */
public interface LoginStateManager<T> {

    /**
     * 以用户对象创建登录态
     * @param tiket 登录成功时产生的通行
     * @param session 类似于session,根据具体需要定义实体类型
     * @return 登录态Key
     */
    void saveSession(String tiket,T session);

    /**
     * 根据key获取
     * @param tiket 登录通行证
     * @return T
     */
    T getSessionByTicket(String tiket);

    /**
     * 移除登录态，退出
     * @param tiket
     */
    void removeSession(String tiket);

}
