package cn.com.duibaboot.ext.autoconfigure.web.login;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.concurrent.RejectedExecutionException;

public class LoginStateService<T> {

    private static final String LOGIN_TICKET = "loginTicket";

    private static TransmittableThreadLocal<LoginState> LOGIN_STATE = new TransmittableThreadLocal<>();

    @Autowired
    private LoginStateManager<T> loginStateManager;
    @Autowired
    private DuibaBootLoginProperties duibaBootLoginProperties;
    @Autowired
    private ApplicationContext applicationContext;

    void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response){
        String loginTicket = "";
        Cookie[] cookies = request.getCookies();
        if(cookies!=null){
            for(Cookie cookie : cookies){
                if(StringUtils.equals(LOGIN_TICKET,cookie.getName())){
                    loginTicket = cookie.getValue();
                }
            }
        }
        LOGIN_STATE.set(new LoginState(request,response,loginTicket));
    }

    LoginState getCurrentLoginState(){
        LoginState state = LOGIN_STATE.get();
        if(state==null){
            throw new RejectedExecutionException("当前线程不是用户请求线程");
        }
        return state;
    }

    /**
     * 获取登录会话实体
     */
    public T getSession(){
        LoginState state = getCurrentLoginState();
        if(state==null||StringUtils.isBlank(state.getLoginTicket())){
            return null;
        }
        return loginStateManager.getSessionByTicket(state.getLoginTicket());
    }

    public void createSession(T session){

        String ticket = UUIDUtils.createSecureUUID();
        LoginState state = getCurrentLoginState();

        loginStateManager.saveSession(ticket,session);

        int expiryDate = duibaBootLoginProperties.getCookieExpiryDate()*24*60*60;

        Cookie cookie = new Cookie(LOGIN_TICKET,ticket);
        cookie.setPath("/");
        cookie.setMaxAge(expiryDate);
        state.getResponse().addCookie(cookie);

        //发布登录成功事件
        LoginSuccessEvent event = new LoginSuccessEvent();
        event.setSession(session);
        event.setRequest(state.getRequest());
        event.setResponse(state.getResponse());
        event.setExpirationTime(expiryDate);
        applicationContext.publishEvent(event);
    }

    void removeRequestInThreadLocal() {
        LOGIN_STATE.remove();
    }
}
