/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import com.netflix.appinfo.ApplicationInfoManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration"})
@ConditionalOnBean(type={"com.netflix.appinfo.ApplicationInfoManager"}, search=SearchStrategy.CURRENT)
public class DiscoveryMetadataAutoConfiguration {
    private static long serverStartUpTime;
    public static final String SERVER_START_UP_TIME_KEY = "serverStartUpTime";
    public static final String WEIGHT_KEY = "weight";
    public static final String RUN_IN_SINGLE_JAR_MODE = "runInSingleJarMode";
    public static final String DUIBA_BOOT_VERSION = "duibaBootVersion";
    public static final String SPRING_BOOT_VERSION = "springBootVersion";
    public static final String CONFIG_VERSION = "configVersion";
    public static final String RUN_IN_DOCKER = "run.in.docker";
    @Autowired
    private ApplicationInfoManager applicationInfoManager;
    @Autowired
    private Environment environment;
    @Value(value="${run.in.docker:false}")
    private boolean runInDocker;
    @Autowired(required=false)
    private List<DiscoveryMetadataRegister> discoveryMetadataRegisters;

    private synchronized long getServerStartUpTime() {
        if (serverStartUpTime == 0L) {
            serverStartUpTime = System.currentTimeMillis();
        }
        return serverStartUpTime;
    }

    @EventListener(value={RefreshScopeRefreshedEvent.class})
    @Order(value=-2147483648)
    public void onRefresh(RefreshScopeRefreshedEvent event) {
        this.registerAppMetadataCommon();
    }

    @PostConstruct
    public void init() {
        this.registerAppMetadataCommon();
    }

    private void registerAppMetadataCommon() {
        long serverStartUpTime = this.getServerStartUpTime();
        if (this.applicationInfoManager != null) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(SERVER_START_UP_TIME_KEY, String.valueOf(serverStartUpTime));
            metadata.put(WEIGHT_KEY, String.valueOf(100));
            metadata.put(RUN_IN_SINGLE_JAR_MODE, SpringBootUtils.isJarInJarMode() ? "true" : "false");
            metadata.put(SPRING_BOOT_VERSION, SpringBootVersion.getVersion());
            metadata.put(DUIBA_BOOT_VERSION, StringUtils.trimToEmpty((String)DuibaBootVersion.getVersion()));
            metadata.put(RUN_IN_DOCKER, this.runInDocker ? "true" : "false");
            metadata.put(CONFIG_VERSION, this.environment.getProperty("config.client.version"));
            if (this.discoveryMetadataRegisters != null) {
                for (DiscoveryMetadataRegister register : this.discoveryMetadataRegisters) {
                    register.registerMetadata(metadata);
                }
            }
            this.applicationInfoManager.registerAppMetadata(metadata);
        }
    }
}

