/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.netflix.ribbon.RibbonServerPredicate;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duiba.wolf.utils.ConcurrentUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.CustomRibbonServerList;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.DevRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonPing;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.http.pool.LeastActiveServerListFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.cloud.netflix.feign.CustomFeignClientsRegistrar;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={LeastActiveServerListFilter.class})
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class RibbonCustomAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RibbonCustomAutoConfiguration.class);
    @Resource
    private SpringClientFactory springClientFactory;

    @Bean
    public ApplicationListener<ContextRefreshedEvent> springClientFactoryInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                if (event.getApplicationContext() instanceof EmbeddedWebApplicationContext) {
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    for (String name : enabledFeignClientNames) {
                        RibbonCustomAutoConfiguration.this.springClientFactory.getClientConfig(name);
                    }
                }
            }
        };
    }

    @Bean
    public IPingStrategy getConcurrentRibbonPingStrategy() {
        return new ConcurrentPingStrategy();
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> iLoadBalancerInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                try {
                    ILoadBalancer bean = (ILoadBalancer)event.getApplicationContext().getBean(ILoadBalancer.class);
                    Field pingStrategyField = ReflectionUtils.findField(bean.getClass(), (String)"pingStrategy");
                    if (pingStrategyField != null) {
                        pingStrategyField.setAccessible(true);
                        ReflectionUtils.setField((Field)pingStrategyField, (Object)bean, (Object)RibbonCustomAutoConfiguration.this.getConcurrentRibbonPingStrategy());
                    } else {
                        logger.error("[NOTIFYME]ILoadBalancer\u4e2d\u7684pingStrategy Field\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4f7f\u7528\u5e76\u53d1ping\u7b56\u7565");
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
        };
    }

    @Bean
    @Profile(value={"dev"})
    public DevRibbonServerListFilter devRibbonServerListFilter() {
        return new DevRibbonServerListFilter(true);
    }

    public static class CustomZoneAvoidanceRule
    extends ZoneAvoidanceRule {
        private final AtomicInteger nextIndex = new AtomicInteger();
        private RibbonServerPredicate compositeRibbonServerPredicate;
        private List<RibbonServerListFilter> ribbonServerListFilters = Collections.emptyList();

        @Autowired(required=false)
        public void setRibbonServerPredicates(List<RibbonServerPredicate> ribbonServerPredicates, List<RibbonServerListFilter> ribbonServerListFilters) {
            if (ribbonServerPredicates != null && !ribbonServerPredicates.isEmpty()) {
                this.compositeRibbonServerPredicate = discoveryEnabledServer -> ribbonServerPredicates.stream().allMatch(p -> p.test(discoveryEnabledServer));
            }
            if (ribbonServerListFilters != null) {
                this.ribbonServerListFilters = ribbonServerListFilters;
            }
        }

        private List<Server> filterServerList(List<Server> serverList) {
            for (RibbonServerListFilter filter2 : this.ribbonServerListFilters) {
                serverList = filter2.filter(serverList);
            }
            if (this.compositeRibbonServerPredicate == null) {
                return serverList;
            }
            ArrayList<Server> filtedList = new ArrayList<Server>();
            for (Server server : serverList) {
                if (!(server instanceof DiscoveryEnabledServer) || !this.compositeRibbonServerPredicate.test((Object)((DiscoveryEnabledServer)server))) continue;
                filtedList.add(server);
            }
            return filtedList;
        }

        public Server choose(Object key) {
            DiscoveryEnabledServer server;
            String isPerfTestSupportted;
            ILoadBalancer lb = this.getLoadBalancer();
            List<Server> eligible = this.getPredicate().getEligibleServers(lb.getReachableServers(), key);
            Server choosedServer = !(eligible = this.filterServerList(eligible)).isEmpty() ? this.chooseRoundRobinWithTimeBasedWeight(eligible) : super.choose(key);
            if (choosedServer != null && choosedServer instanceof DiscoveryEnabledServer && !"1".equals(isPerfTestSupportted = (String)(server = (DiscoveryEnabledServer)choosedServer).getInstanceInfo().getMetadata().get("isPerfTestSupportted")) && PerfTestContext.isCurrentInPerfTestMode()) {
                throw new IllegalStateException("\u8bc6\u522b\u5230\u5f53\u524d\u8bf7\u6c42\u662f\u538b\u6d4b\u6d41\u91cf\uff0c\u4f46\u662f\u8c03\u7528\u7684\u670d\u52a1\u4e0d\u652f\u6301\u6027\u80fd\u538b\u6d4b\uff0c\u653e\u5f03\u672c\u6b21\u8bf7\u6c42\uff0c\u8bf7\u901a\u77e5\u8be5\u670d\u52a1\u8d1f\u8d23\u4eba\u52a0\u5165spring-boot-starter-perftest\u4f9d\u8d56\uff1b\u5c1d\u8bd5\u8c03\u7528\u7684\u670d\u52a1\u7aef\uff1a" + server.getInstanceInfo().getVIPAddress() + ",ip:" + server.getInstanceInfo().getIPAddr() + ",port:" + server.getInstanceInfo().getPort());
            }
            return choosedServer;
        }

        private Server chooseRoundRobinWithTimeBasedWeight(List<Server> eligible) {
            int length = eligible.size();
            int totalWeight = 0;
            boolean sameWeight = true;
            int[] weights = new int[length];
            for (int i = 0; i < length; ++i) {
                int weight;
                weights[i] = weight = this.getTimeBasedWeight(eligible.get(i));
                totalWeight += weight;
                if (!sameWeight || i <= 0 || weight == weights[i - 1]) continue;
                sameWeight = false;
            }
            if (totalWeight > 0 && !sameWeight) {
                int offset = this.nextIndex.getAndIncrement() % totalWeight;
                for (int i = 0; i < length; ++i) {
                    if ((offset -= weights[i]) >= 0) continue;
                    return eligible.get(i);
                }
            }
            return eligible.get(this.nextIndex.getAndIncrement() % eligible.size());
        }

        private int getTimeBasedWeight(Server server) {
            int weight = 100;
            if (server instanceof DiscoveryEnabledServer) {
                String weightStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("weight");
                weight = NumberUtils.parseInt((String)weightStr, (int)100);
                weight = Math.max(weight, 0);
            }
            if (weight > 0) {
                long timestamp = 0L;
                if (server instanceof DiscoveryEnabledServer) {
                    String tsStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("serverStartUpTime");
                    timestamp = NumberUtils.parseLong((String)tsStr, (long)0L);
                    timestamp = Math.max(timestamp, 0L);
                }
                if (timestamp > 0L) {
                    int uptime = (int)(System.currentTimeMillis() - timestamp);
                    int warmup = 300000;
                    if (uptime > 0 && uptime < warmup) {
                        weight = this.calculateWarmupWeight(uptime, warmup, weight);
                    }
                }
            }
            return weight;
        }

        private int calculateWarmupWeight(int uptime, int warmup, int weight) {
            int ww = (int)((float)uptime / ((float)warmup / (float)weight));
            if (ww < 1) {
                return 1;
            }
            return ww > weight ? weight : ww;
        }
    }

    private static class ConcurrentPingStrategy
    implements IPingStrategy,
    DisposableBean {
        private final ExecutorService executor = Executors.newFixedThreadPool(20, (ThreadFactory)new NamedThreadFactory("ribbonPing"));
        private static final Logger logger = LoggerFactory.getLogger(ConcurrentPingStrategy.class);

        private ConcurrentPingStrategy() {
        }

        public boolean[] pingServers(IPing ping, Server[] servers) {
            int numCandidates = servers.length;
            boolean[] results = new boolean[numCandidates];
            if (logger.isDebugEnabled()) {
                logger.debug("LoadBalancer:  PingTask executing [" + numCandidates + "] servers configured");
            }
            if (ping == null) {
                logger.error("IPing is null, will mark all servers as not alive");
                return results;
            }
            ArrayList<Callable<Boolean>> callables = new ArrayList<Callable<Boolean>>();
            for (Server server : servers) {
                callables.add(() -> ping.isAlive(server));
            }
            if (this.executor.isTerminated()) {
                return results;
            }
            try {
                List ret = ConcurrentUtils.submitTasksBlocking((Executor)this.executor, callables);
                int i = 0;
                for (Boolean b : ret) {
                    results[i++] = b;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return results;
        }

        public void destroy() throws Exception {
            this.executor.shutdown();
        }
    }

    private static class CustomPropertiesFactory
    extends PropertiesFactory {
        @Resource
        ApplicationContext context;

        private CustomPropertiesFactory() {
        }

        public String getClassName(Class clazz, String name) {
            if (clazz.equals(IRule.class)) {
                return CustomZoneAvoidanceRule.class.getName();
            }
            if (clazz.equals(IPing.class)) {
                return RibbonPing.class.getName();
            }
            if (clazz.equals(ServerList.class)) {
                return CustomRibbonServerList.class.getName();
            }
            return super.getClassName(clazz, name);
        }

        public <C> C get(Class<C> clazz, IClientConfig config, String name) {
            if (!ServerList.class.equals(clazz)) {
                return (C)super.get(clazz, config, name);
            }
            String className = this.getClassName(clazz, name);
            if (StringUtils.hasText((String)className)) {
                try {
                    Class<?> toInstantiate = Class.forName(className);
                    return (C)this.instantiateWithConfig(this.context, toInstantiate, config);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unknown class to load " + className + " for class " + clazz + " named " + name);
                }
            }
            return null;
        }

        <C> C instantiateWithConfig(ApplicationContext context, Class<C> clazz, IClientConfig config) {
            Object result = null;
            try {
                Constructor<C> constructor = clazz.getConstructor(IClientConfig.class);
                result = constructor.newInstance(config);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (result == null) {
                result = BeanUtils.instantiate(clazz);
                if (result instanceof IClientConfigAware) {
                    ((IClientConfigAware)result).initWithNiwsConfig(config);
                }
                if (context != null) {
                    context.getAutowireCapableBeanFactory().autowireBean(result);
                }
            }
            return (C)result;
        }
    }

    @Configuration
    @AutoConfigureBefore(value={RibbonAutoConfiguration.class})
    @ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
    public static class RibbonPropertiesFactoryConfiguration {
        @Bean
        public PropertiesFactory propertiesFactory() {
            return new CustomPropertiesFactory();
        }
    }
}

