/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.aop.framework.ProxyFactory;

class HttpClientHystrixMethodInterceptor
implements HttpClientMethodInterceptor {
    HttpClientHystrixMethodInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String host;
        if (!"execute".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArguments();
        HttpUriRequest httpUriRequest = null;
        HttpHost httpPost = null;
        for (Object arg : args) {
            if (arg instanceof HttpUriRequest) {
                httpUriRequest = (HttpUriRequest)arg;
                break;
            }
            if (!(arg instanceof HttpHost)) continue;
            httpPost = (HttpHost)arg;
            break;
        }
        if (httpUriRequest != null) {
            host = httpUriRequest.getURI().getHost();
        } else if (httpPost != null) {
            host = httpPost.getHostName();
        } else {
            return invocation.proceed();
        }
        HttpClientHystrixCommand hystrixCommand = new HttpClientHystrixCommand(invocation, host);
        Object obj = hystrixCommand.execute();
        if (obj instanceof CloseableHttpResponse) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setTarget(obj);
            proxyFactory.addAdvice((Advice)new HttpResponseMethodInterceptor());
            return proxyFactory.getProxy();
        }
        return obj;
    }

    public int getOrder() {
        return 1;
    }

    private static class HttpClientHystrixCommand
    extends HystrixCommand<Object> {
        MethodInvocation invocation;
        String host;

        HttpClientHystrixCommand(MethodInvocation invocation, String host) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"httpClient")).andCommandKey(HystrixCommandKey.Factory.asKey((String)("httpClient(" + StringUtils.replace((String)host, (String)".", (String)",") + ")"))).andCommandPropertiesDefaults(HystrixCommandProperties.defaultSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(200).withExecutionTimeoutEnabled(false)));
            this.invocation = invocation;
            this.host = host;
        }

        protected Object run() throws Exception {
            try {
                return this.invocation.proceed();
            }
            catch (Error | Exception e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private static class HttpResponseMethodInterceptor
    implements MethodInterceptor {
        private HttpResponseMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if ("close".equals(invocation.getMethod().getName()) && invocation.getMethod().getParameterCount() == 0) {
                ((CloseableHttpResponse)invocation.getThis()).getEntity().getContent().close();
                return null;
            }
            return invocation.proceed();
        }
    }
}

