/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.logger.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="duiba.logger.size-limit")
public class LoggerSizeFilter
extends Filter<ILoggingEvent> {
    private int errorThreshold = 32768;
    private int warnThreshold = 16384;
    private static final Logger logger = LoggerFactory.getLogger((String)"LoggerSizeFilter");

    public FilterReply decide(ILoggingEvent event) {
        if (event == null || event.getThrowableProxy() != null || event.getLoggerName().equals(logger.getName())) {
            return FilterReply.NEUTRAL;
        }
        int loggerSize = event.getFormattedMessage().length();
        if (loggerSize > this.errorThreshold) {
            logger.warn("logsize:{} exceed duiba.logger.size-limit.error-threshold: {}, loggerName:{}", new Object[]{loggerSize, this.errorThreshold, event.getLoggerName()});
            return FilterReply.DENY;
        }
        if (loggerSize > this.warnThreshold) {
            logger.error("logsize:{} exceed duiba.logger.size-limit.warn-threshold: {}, loggerName:{}", new Object[]{loggerSize, this.warnThreshold, event.getLoggerName()});
            return FilterReply.NEUTRAL;
        }
        return FilterReply.NEUTRAL;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public void setErrorThreshold(int errorThreshold) {
        if (errorThreshold < 1024) {
            logger.warn("property `duiba.logger.size-limit.error-threshold={}` is invalid, will use default value{}", (Object)errorThreshold, (Object)this.errorThreshold);
            return;
        }
        this.errorThreshold = errorThreshold;
    }

    public int getWarnThreshold() {
        return this.warnThreshold;
    }

    public void setWarnThreshold(int warnThreshold) {
        if (warnThreshold < 1024) {
            logger.warn("property `duiba.logger.size-limit.warn-threshold={}` is invalid, will use default value{}", (Object)warnThreshold, (Object)this.warnThreshold);
            return;
        }
        this.warnThreshold = warnThreshold;
    }
}

