package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter
import cn.com.duiba.boot.utils.NetUtils
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataAutoConfiguration
import com.netflix.loadbalancer.Server
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer

/**
 * 此类用于开发环境，开发环境下feign会优先调用本机服务，如果没有本机服务，则优先调用jar方式启动的服务
 */
data class DevRibbonServerListFilter(var isRunInDevMode : Boolean): RibbonServerListFilter {
    override fun filter(serverList: List<Server>): List<Server> {
        if(!isRunInDevMode || !serverList.stream().allMatch({ s -> s is DiscoveryEnabledServer })) {
            return serverList
        }

        var retList : MutableList<Server> = ArrayList()
        for (server in serverList){
            if(server is DiscoveryEnabledServer){
                //添加和本机ip相同的Server
                if(server.instanceInfo.ipAddr.equals(NetUtils.getLocalIp())){
                    retList.add(server)
                }
            }
        }

        //如果没有本机的服务，则使用jar启动的服务
        if(retList.isEmpty()){
            for (server in serverList){
                if(server is DiscoveryEnabledServer){
                    //添加jar启动的的Server
                    if(!"false".equals(server.instanceInfo.metadata[DiscoveryMetadataAutoConfiguration.RUN_IN_SINGLE_JAR_MODE])){
                        retList.add(server)
                    }
                }
            }
        }

        return if(retList.isEmpty()) serverList else retList
    }
}
