package cn.com.duibaboot.ext.autoconfigure.logger;

import cn.com.duibaboot.ext.autoconfigure.core.utils.FileUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 在Docker环境下，应用启动时修改日志中没带时间的log文件
 */
public class DockerApplicationLogRenameListener implements SpringApplicationRunListener {

    private static final Boolean IS_DORKER_ENV = Boolean.valueOf(System.getenv("RUN_IN_DOCKER"));

    private static final AtomicBoolean IS_RUN_ED = new AtomicBoolean(false);

    private Pattern pattern = Pattern.compile("^[a-zA-Z]+\\.log$");

    public DockerApplicationLogRenameListener(SpringApplication application, String[] args){
        //do nothing
    }


    @Override
    public void starting() {
        //防止启动两次
        if(!IS_RUN_ED.compareAndSet(Boolean.FALSE,Boolean.TRUE)){
            return;
        }
        //只有在Dorker环境才运行
        if(!IS_DORKER_ENV){
            return;
        }

        File logRootPath = new File(FileUtils.getLogRootPath());
        SimpleDateFormat minute = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        Date time = new Date();
        String timeStr = minute.format(time);

        List<File> fileList = FileUtils.findAllFileByRootPath(logRootPath);
        for(File file:fileList){
            Matcher matcher = pattern.matcher(file.getName());
            if(!matcher.matches()){
                continue;
            }
            String fileName = FileUtils.getFileName(file);
            String fileSuffix = FileUtils.getFileSuffix(file);
            String newFileName = fileName+"_"+timeStr+fileSuffix;
            FileUtils.rename(file,newFileName);
        }
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment configurableEnvironment) {
        //do nothing
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext configurableApplicationContext) {
        //do nothing
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext configurableApplicationContext) {
        //do nothing
    }

    @Override
    public void finished(ConfigurableApplicationContext configurableApplicationContext, Throwable throwable) {
        //do nothing
    }
}
