/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthHbasePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthMybatisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.elasticsearch.client.transport.TransportClient;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.sleuth.Span;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class SleuthAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SleuthAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={HbaseTemplate.class, HTable.class, Span.class, Aspect.class})
    public static class SleuthHbaseConfiguration {
        @Bean
        public SleuthHbasePlugin sleuthHbasePlugin() {
            return new SleuthHbasePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransportClient.class, ElasticsearchOperations.class, Span.class, Aspect.class})
    public static class SleuthElasticsearchConfiguration {
        @Bean
        public SleuthElasticSearchPlugin sleuthElasticSearchPlugin() {
            return new SleuthElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Span.class, Aspect.class, MongoOperations.class})
    public static class SleuthMongodbConfiguration {
        @Bean
        public SleuthMongodbPlugin sleuthMongodbPlugin() {
            return new SleuthMongodbPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthSpringDataRedisAspectConfiguration {
        @Bean
        public SleuthSpringDataRedisPlugin sleuthSpringDataRedisAspectPlugin() {
            return new SleuthSpringDataRedisPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthRedisPluginConfiguration {
        @Bean
        public SleuthRedisPlugin sleuthRedisPlugin() {
            return new SleuthRedisPlugin();
        }
    }

    private static class SleuthMybatisBeanPostProcessor
    implements SpecifiedBeanPostProcessor<Object> {
        @Resource
        private SleuthMybatisPlugin sleuthMybatisPlugin;

        private SleuthMybatisBeanPostProcessor() {
        }

        public int getOrder() {
            return -1;
        }

        @Override
        public Class<Object> getBeanType() {
            return Object.class;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            SqlSessionFactory s = null;
            if (bean instanceof SqlSessionFactory) {
                s = (SqlSessionFactory)bean;
            }
            if (bean instanceof SqlSessionTemplate) {
                s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
            }
            if (s == null) {
                return bean;
            }
            this.addInterceptor(s);
            return bean;
        }

        private void addInterceptor(SqlSessionFactory s) {
            boolean hasCatPlugin = false;
            if (!CollectionUtils.isEmpty((Collection)s.getConfiguration().getInterceptors())) {
                for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                    if (!(plugin instanceof SleuthMybatisPlugin)) continue;
                    hasCatPlugin = true;
                    break;
                }
            }
            if (!hasCatPlugin) {
                s.getConfiguration().addInterceptor((Interceptor)this.sleuthMybatisPlugin);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, Span.class})
    public static class SleuthMyBatisPostProcessorConfiguration {
        @Bean
        public SleuthMybatisPlugin sleuthMybatisPlugin() {
            return new SleuthMybatisPlugin();
        }

        @Bean
        public static SpecifiedBeanPostProcessor sleuthMyBatisPostProcessorConfigurer() {
            return new SleuthMybatisBeanPostProcessor();
        }
    }
}

