/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestContext;
import com.aliyun.openservices.ons.api.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class OnsPerfAspect {
    private static final Logger logger = LoggerFactory.getLogger(OnsPerfAspect.class);

    @Around(value="execution(* com.aliyun.openservices.ons.api.Producer+.*(..))")
    public Object onsSendJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            PerfTestContext.debugInfo((String)"onsProducer");
            Object[] args = joinPoint.getArgs();
            if (methodName.startsWith("send") && args[0] instanceof Message) {
                Message rawMsg = (Message)args[0];
                rawMsg.putUserProperties("perfTest", "true");
                return joinPoint.proceed(args);
            }
        }
        return joinPoint.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* com.aliyun.openservices.ons.api.MessageListener+.*(..))")
    public Object onsConsumeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Message rawMsg;
        Object[] args;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (methodName.equals("consume") && (args = joinPoint.getArgs())[0] instanceof Message && "true".equals((rawMsg = (Message)args[0]).getUserProperties("perfTest"))) {
            PerfTestContext._setPerfTestMode((Boolean)true);
            PerfTestContext.debugInfo((String)"onsConsumer");
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                PerfTestContext._setPerfTestMode((Boolean)false);
            }
        }
        return joinPoint.proceed();
    }
}

