/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHandlerMapping;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService;

@Configuration
@ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
@ConditionalOnClass(value={TransmittableThreadLocal.class, WebSocketHandlerMapping.class, AbstractWebSocketMessageBrokerConfigurer.class})
public class WebSocketPerfTestConfiguration {
    @Bean
    public static SpecifiedBeanPostProcessor<WebSocketHandlerMapping> webSocketHandlerMappingSpecifiedBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<WebSocketHandlerMapping>(){

            @Override
            public Class<WebSocketHandlerMapping> getBeanType() {
                return WebSocketHandlerMapping.class;
            }

            @Override
            public Object postProcessBeforeInitialization(WebSocketHandlerMapping bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(WebSocketHandlerMapping bean, String beanName) throws BeansException {
                for (SockJsHttpRequestHandler rh : bean.getUrlMap().values()) {
                    ((TransportHandlingSockJsService)rh.getSockJsService()).getHandshakeInterceptors().add(0, new HandshakeInterceptor(){

                        public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
                            ServletServerHttpRequest req;
                            if (request instanceof ServletServerHttpRequest && PerfTestUtils.isPerfTestRequest((HttpServletRequest)(req = (ServletServerHttpRequest)request).getServletRequest())) {
                                attributes.put("_duibaPerf", true);
                            }
                            return true;
                        }

                        public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
                        }
                    });
                }
                return bean;
            }

            public int getOrder() {
                return 0;
            }
        };
    }

    @Bean
    public AbstractWebSocketMessageBrokerConfigurer bootWebSocketMessageBrokerConfigurer() {
        return new AbstractWebSocketMessageBrokerConfigurer(){

            public void registerStompEndpoints(StompEndpointRegistry registry) {
            }

            public void configureClientInboundChannel(ChannelRegistration registration) {
                registration.interceptors(new ChannelInterceptor[]{new ExecutorChannelInterceptor(){

                    public Message<?> preSend(Message<?> message, MessageChannel channel) {
                        return message;
                    }

                    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
                    }

                    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
                    }

                    public boolean preReceive(MessageChannel channel) {
                        return true;
                    }

                    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
                        return message;
                    }

                    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
                    }

                    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
                        Map sessionAttr = (Map)message.getHeaders().get((Object)"simpSessionAttributes");
                        if (sessionAttr != null && Boolean.TRUE.equals(sessionAttr.get("_duibaPerf"))) {
                            PerfTestContext._setPerfTestMode((Boolean)true);
                        }
                        return message;
                    }

                    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
                        PerfTestContext._setPerfTestMode((Boolean)false);
                    }
                }});
            }
        };
    }
}

