/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginSuccessEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.event.EventListener;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CsrfDefensivePolicy
extends HandlerInterceptorAdapter {
    private static final String CSRF_HEADER = "X-Csrf-Token";
    private static final String CSRF_COOKIE = "csrf_token";
    public static final String CSRF_PASS_MARK = "CSRF_PASS_MARK";

    @EventListener(value={LoginSuccessEvent.class})
    public void csrfCookieListening(LoginSuccessEvent event) {
        String csrfToken = UUIDUtils.createUUID();
        Cookie cookie = new Cookie(CSRF_COOKIE, csrfToken);
        cookie.setPath("/");
        cookie.setMaxAge(event.getExpirationTime().intValue());
        event.getResponse().addCookie(cookie);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (DispatcherType.REQUEST != request.getDispatcherType()) {
            return true;
        }
        if (Optional.ofNullable(request.getAttribute(CSRF_PASS_MARK)).map(mark -> (Boolean)mark).orElse(false).booleanValue()) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        String csrfTokenInCookie = this.getCookieValue(request);
        CsrfOff csrfOffAnno = (CsrfOff)handlerMethod.getMethodAnnotation(CsrfOff.class);
        if (!this.isAjaxRequest(handlerMethod) || csrfOffAnno != null || StringUtils.isBlank((String)csrfTokenInCookie)) {
            return true;
        }
        String referer = request.getHeader("referer");
        if (!StringUtils.isEmpty((String)referer) && !referer.startsWith(RequestTool.getServerPath((HttpServletRequest)request))) {
            throw new DuibaSecurityException("invalid csrf token");
        }
        String csrfTokenInHeader = request.getHeader(CSRF_HEADER);
        if (!StringUtils.equals((String)csrfTokenInCookie, (String)csrfTokenInHeader)) {
            throw new DuibaSecurityException("invalid csrf token");
        }
        return true;
    }

    private boolean isAjaxRequest(HandlerMethod handlerMethod) {
        ResponseBody responseBodyAnno = (ResponseBody)handlerMethod.getMethodAnnotation(ResponseBody.class);
        RestController restAnno = handlerMethod.getBeanType().getAnnotation(RestController.class);
        return responseBodyAnno != null || restAnno != null || handlerMethod.getMethod().getReturnType().equals(Void.TYPE);
    }

    private List<String> getCookieValues(HttpServletRequest request) {
        ArrayList<String> values = new ArrayList<String>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!CSRF_COOKIE.equals(c.getName())) continue;
                String value = c.getValue();
                values.add(value);
            }
        }
        return values;
    }

    private String getCookieValue(HttpServletRequest request) {
        List<String> values = this.getCookieValues(request);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(values.size() - 1);
    }
}

