package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import org.quartz.spi.ThreadExecutor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * 让任务线程延迟启动
 */
public class DelayedThreadExecutor implements ThreadExecutor {

    private static final List<Thread> threadList = new CopyOnWriteArrayList<>();

    @Override
    public void execute(Thread thread) {
        threadList.add(thread);
    }

    @Override
    public void initialize() {
        //do nothing
    }

    public static synchronized void startAllTaskThreads(){
        for(Thread thread : threadList){
            thread.start();
        }

        threadList.clear();
    }
}
