package cn.com.duibaboot.ext.autoconfigure.javaagent.core.match;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static net.bytebuddy.matcher.ElementMatchers.*;

/**
 * Match the class by the given super class or interfaces.
 *

 */
public class HierarchyMatch implements IndirectMatch {
    private String[] parentTypes;

    private HierarchyMatch(String[] parentTypes) {
        if (parentTypes == null || parentTypes.length == 0) {
            throw new IllegalArgumentException("parentTypes is null");
        }
        this.parentTypes = parentTypes;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = not(isInterface())
                .and(not(isEnum()))
                .and(not(isAbstract()));
        for (String superTypeName : parentTypes) {
            junction = junction.and(buildSuperClassMatcher(superTypeName));
        }
        return junction;
    }

    private ElementMatcher.Junction buildSuperClassMatcher(String superTypeName) {
        return hasSuperType(named(superTypeName));
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        List<String> parentTypes = new ArrayList<>(Arrays.asList(this.parentTypes));

        TypeList.Generic implInterfaces = typeDescription.getInterfaces();
        for (TypeDescription.Generic implInterface : implInterfaces) {
            matchHierarchyClass(implInterface, parentTypes);
        }

        matchHierarchyClass(typeDescription.getSuperClass(), parentTypes);

        if (parentTypes.isEmpty()) {
            return true;
        }

        return false;
    }

    private void matchHierarchyClass(TypeDescription.Generic clazz, List<String> parentTypes) {
        parentTypes.remove(clazz.asErasure().getActualName());//(clazz.getTypeName());
        if (parentTypes.isEmpty()) {
            return;
        }

        for (TypeDescription.Generic generic : clazz.getInterfaces()) {
            matchHierarchyClass(generic, parentTypes);
        }

        TypeDescription.Generic superClazz = clazz.getSuperClass();
        if (superClazz != null && !clazz.getTypeName().equals("java.lang.Object")) {
            matchHierarchyClass(superClazz, parentTypes);
        }

    }

    public static ClassMatch byHierarchyMatch(String[] parentTypes) {
        return new HierarchyMatch(parentTypes);
    }
}
