package cn.com.duibaboot.ext.autoconfigure.perftest.filter;

import java.util.concurrent.atomic.AtomicInteger;

class RejectedCountDto{
    /**
     * 被拒绝服务的次数
     */
    private AtomicInteger rejectedCount = new AtomicInteger(0);

    /**
     * 是否记录过日志
     */
    protected volatile boolean isLogged = false;

    /**
     * 是否应该熔断压测请求
     * @return
     */
    protected boolean isCircuitBreak(){
        return rejectedCount.get() > 10;
    }

    /**
     * 增加压测请求被拒绝的次数
     */
    protected void incrRejectedCount(){
        rejectedCount.incrementAndGet();
    }
}
