/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.PerfTestRibbonServerListFilter;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lcn/com/duibaboot/ext/autoconfigure/cloud/netflix/ribbon/PerfTestRibbonServerListFilter;", "Lcn/com/duiba/boot/netflix/ribbon/RibbonServerListFilter;", "thisServerPerfTestSceneId", "", "(Ljava/lang/String;)V", "getThisServerPerfTestSceneId", "()Ljava/lang/String;", "setThisServerPerfTestSceneId", "component1", "copy", "equals", "", "other", "", "filter", "", "Lcom/netflix/loadbalancer/Server;", "serverList", "key", "hashCode", "", "toString", "spring-boot-ext"})
public final class PerfTestRibbonServerListFilter
implements RibbonServerListFilter {
    @NotNull
    private String thisServerPerfTestSceneId;

    @NotNull
    public List<Server> filter(@NotNull List<? extends Server> serverList, @Nullable Object key) {
        Intrinsics.checkParameterIsNotNull(serverList, (String)"serverList");
        if (serverList.isEmpty() || !serverList.stream().allMatch(filter.1.INSTANCE)) {
            return serverList;
        }
        List retList = new ArrayList();
        for (Server server : serverList) {
            if (!(server instanceof DiscoveryEnabledServer)) continue;
            InstanceInfo instanceInfo = ((DiscoveryEnabledServer)server).getInstanceInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)instanceInfo, (String)"server.instanceInfo");
            String serverPerfSceneId = (String)instanceInfo.getMetadata().get("duiba.perf.scene.id");
            if (StringUtils.isBlank((String)this.thisServerPerfTestSceneId) && StringUtils.isBlank((String)serverPerfSceneId)) {
                retList.add(server);
                continue;
            }
            if (!StringUtils.equals((String)this.thisServerPerfTestSceneId, (String)serverPerfSceneId)) continue;
            retList.add(server);
        }
        if (retList.isEmpty() && !StringUtils.isBlank((String)this.thisServerPerfTestSceneId)) {
            Object e = serverList.get(0);
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.netflix.niws.loadbalancer.DiscoveryEnabledServer");
            }
            InstanceInfo instanceInfo = ((DiscoveryEnabledServer)e).getInstanceInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)instanceInfo, (String)"(serverList.get(0) as Di\u2026abledServer).instanceInfo");
            String dependencyAppName = instanceInfo.getAppName();
            throw (Throwable)new IllegalStateException("\u5728\u8fdb\u884cspring-cloud\u8c03\u7528\u524d\u68c0\u6d4b\u5230\u5f53\u524d\u5b9e\u4f8b\u4e3a\u538b\u6d4b\u4e13\u7528\u5b9e\u4f8b\uff0c\u4f46\u662f\u6ca1\u6709\u627e\u5230" + dependencyAppName + "\u7684\u538b\u6d4b\u4e13\u7528\u5b9e\u4f8b\uff0c\u62d2\u7edd\u8c03\u7528\u3002\uff08\u538b\u6d4b\u573a\u666fID:" + this.thisServerPerfTestSceneId + "\uff09");
        }
        return retList.isEmpty() ? serverList : retList;
    }

    @NotNull
    public final String getThisServerPerfTestSceneId() {
        return this.thisServerPerfTestSceneId;
    }

    public final void setThisServerPerfTestSceneId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.thisServerPerfTestSceneId = string;
    }

    public PerfTestRibbonServerListFilter(@NotNull String thisServerPerfTestSceneId) {
        Intrinsics.checkParameterIsNotNull((Object)thisServerPerfTestSceneId, (String)"thisServerPerfTestSceneId");
        this.thisServerPerfTestSceneId = thisServerPerfTestSceneId;
    }

    @NotNull
    public final String component1() {
        return this.thisServerPerfTestSceneId;
    }

    @NotNull
    public final PerfTestRibbonServerListFilter copy(@NotNull String thisServerPerfTestSceneId) {
        Intrinsics.checkParameterIsNotNull((Object)thisServerPerfTestSceneId, (String)"thisServerPerfTestSceneId");
        return new PerfTestRibbonServerListFilter(thisServerPerfTestSceneId);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PerfTestRibbonServerListFilter copy$default(PerfTestRibbonServerListFilter perfTestRibbonServerListFilter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = perfTestRibbonServerListFilter.thisServerPerfTestSceneId;
        }
        return perfTestRibbonServerListFilter.copy(string);
    }

    public String toString() {
        return "PerfTestRibbonServerListFilter(thisServerPerfTestSceneId=" + this.thisServerPerfTestSceneId + ")";
    }

    public int hashCode() {
        String string = this.thisServerPerfTestSceneId;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PerfTestRibbonServerListFilter)) break block3;
                PerfTestRibbonServerListFilter perfTestRibbonServerListFilter = (PerfTestRibbonServerListFilter)object;
                if (!Intrinsics.areEqual((Object)this.thisServerPerfTestSceneId, (Object)perfTestRibbonServerListFilter.thisServerPerfTestSceneId)) break block3;
            }
            return true;
        }
        return false;
    }
}

